/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.PartGroundDevice;
import minecrafttransportsimulator.entities.instances.PartPropeller;
import minecrafttransportsimulator.items.instances.ItemPartEngine;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketPartEngine;
import minecrafttransportsimulator.systems.ConfigSystem;
import minecrafttransportsimulator.systems.LanguageSystem;

public class PartEngine
extends APart {
    public static final String ELECTRICITY_FUEL = "electricity";
    public boolean backfired;
    public boolean badShift;
    public boolean running;
    public byte forwardsGears;
    public byte reverseGears;
    public int upshiftCountdown;
    public int downshiftCountdown;
    public int internalFuel;
    public double rpm;
    public double temp;
    public double pressure;
    public double propellerGearboxRatio;
    public double fuelFlow;
    public double rocketFuelUsed;
    public PartEngine linkedEngine;
    private boolean autoStarterEngaged;
    private int starterLevel;
    private int shiftCooldown;
    private double lowestWheelVelocity;
    private double desiredWheelVelocity;
    private double engineAxialVelocity;
    private float wheelFriction;
    private double ambientTemp;
    private double coolingFactor;
    private double engineTargetRPM;
    private double engineRotation;
    private double prevEngineRotation;
    private double driveshaftRotation;
    private double prevDriveshaftRotation;
    private final List<PartGroundDevice> linkedWheels = new ArrayList<PartGroundDevice>();
    private final List<PartGroundDevice> drivenWheels = new ArrayList<PartGroundDevice>();
    private final List<PartPropeller> linkedPropellers = new ArrayList<PartPropeller>();
    private final Point3D engineAxisVector = new Point3D();
    private final Point3D engineForce = new Point3D();
    private double engineForceValue;
    public static final String HOURS_VARIABLE = "engine_hours";
    public final ComputedVariable magnetoVar;
    public final ComputedVariable electricStarterVar;
    public final ComputedVariable handStarterVar;
    public final ComputedVariable currentGearVar;
    public final ComputedVariable shiftUpVar;
    public final ComputedVariable shiftDownVar;
    public final ComputedVariable shiftNeutralVar;
    public final ComputedVariable shiftSelectionVar;
    public final ComputedVariable hoursVar;
    private final ComputedVariable maxRPMVar;
    private final ComputedVariable maxSafeRPMVar;
    private final ComputedVariable revLimitRPMVar;
    private final ComputedVariable revLimitBounceVar;
    private final ComputedVariable revResistanceVar;
    private final ComputedVariable idleRPMVar;
    private final ComputedVariable startRPMVar;
    private final ComputedVariable stallRPMVar;
    private final ComputedVariable starterPowerVar;
    private final ComputedVariable fuelConsumptionVar;
    private final ComputedVariable heatingCoefficientVar;
    private final ComputedVariable coolingCoefficientVar;
    private final ComputedVariable superchargerFuelConsumptionVar;
    private final ComputedVariable superchargerEfficiencyVar;
    private final ComputedVariable gearRatioVar;
    private final ComputedVariable forceShiftVar;
    public final ComputedVariable isAutomaticVar;
    private final ComputedVariable wearFactorVar;
    private final ComputedVariable winddownRateVar;
    private final ComputedVariable jetPowerFactorVar;
    private final ComputedVariable bypassRatioVar;
    public static final float COLD_TEMP = 30.0f;
    public static final float OVERHEAT_TEMP_1 = 115.556f;
    public static final float OVERHEAT_TEMP_2 = 121.111f;
    public static final float FAILURE_TEMP = 132.222f;
    public static final float LOW_OIL_PRESSURE = 40.0f;
    public static final float MAX_SHIFT_SPEED = 0.35f;

    public PartEngine(AEntityF_Multipart<?> entityOn, IWrapperPlayer placingPlayer, JSONPartDefinition placementDefinition, ItemPartEngine item, IWrapperNBT data) {
        super(entityOn, placingPlayer, placementDefinition, item, data);
        if (data != null) {
            this.running = data.getBoolean("running");
            this.rpm = data.getDouble("rpm");
            this.temp = data.getDouble("temp");
            this.pressure = data.getDouble("pressure");
            this.rocketFuelUsed = data.getDouble("rocketFuelUsed");
        }
        for (float gear : ((JSONPart)this.definition).engine.gearRatios) {
            if (gear < 0.0f) {
                this.reverseGears = (byte)(this.reverseGears + 1);
                continue;
            }
            if (!(gear > 0.0f)) continue;
            this.forwardsGears = (byte)(this.forwardsGears + 1);
        }
        this.magnetoVar = new ComputedVariable(this, "engine_magneto", data);
        this.addVariable(this.magnetoVar);
        this.electricStarterVar = new ComputedVariable(this, "engine_starter", data);
        this.addVariable(this.electricStarterVar);
        this.handStarterVar = new ComputedVariable(this, "engine_starter_hand", data);
        this.addVariable(this.handStarterVar);
        this.currentGearVar = new ComputedVariable(this, "engine_gear", data);
        this.addVariable(this.currentGearVar);
        this.shiftUpVar = new ComputedVariable(this, "engine_shift_up", data);
        this.addVariable(this.shiftUpVar);
        this.shiftDownVar = new ComputedVariable(this, "engine_shift_down", data);
        this.addVariable(this.shiftDownVar);
        this.shiftNeutralVar = new ComputedVariable(this, "engine_shift_neutral", data);
        this.addVariable(this.shiftNeutralVar);
        this.shiftSelectionVar = new ComputedVariable(this, "engine_shift_request", data);
        this.addVariable(this.shiftSelectionVar);
        this.hoursVar = new ComputedVariable(this, HOURS_VARIABLE, data);
        this.addVariable(this.hoursVar);
        this.maxRPMVar = new ComputedVariable(this, "maxRPM");
        this.addVariable(this.maxRPMVar);
        this.maxSafeRPMVar = new ComputedVariable(this, "maxSafeRPM");
        this.addVariable(this.maxSafeRPMVar);
        this.revLimitRPMVar = new ComputedVariable(this, "revlimitRPM");
        this.addVariable(this.revLimitRPMVar);
        this.revLimitBounceVar = new ComputedVariable(this, "revlimitBounce");
        this.addVariable(this.revLimitBounceVar);
        this.revResistanceVar = new ComputedVariable(this, "revResistance");
        this.addVariable(this.revResistanceVar);
        this.idleRPMVar = new ComputedVariable(this, "idleRPM");
        this.addVariable(this.idleRPMVar);
        this.startRPMVar = new ComputedVariable(this, "startRPM");
        this.addVariable(this.startRPMVar);
        this.stallRPMVar = new ComputedVariable(this, "stallRPM");
        this.addVariable(this.stallRPMVar);
        this.starterPowerVar = new ComputedVariable(this, "starterPower");
        this.addVariable(this.starterPowerVar);
        this.fuelConsumptionVar = new ComputedVariable(this, "fuelConsumption");
        this.addVariable(this.fuelConsumptionVar);
        this.heatingCoefficientVar = new ComputedVariable(this, "heatingCoefficient");
        this.addVariable(this.heatingCoefficientVar);
        this.coolingCoefficientVar = new ComputedVariable(this, "coolingCoefficient");
        this.addVariable(this.coolingCoefficientVar);
        this.superchargerFuelConsumptionVar = new ComputedVariable(this, "superchargerFuelConsumption");
        this.addVariable(this.superchargerFuelConsumptionVar);
        this.superchargerEfficiencyVar = new ComputedVariable(this, "superchargerEfficiency");
        this.addVariable(this.superchargerEfficiencyVar);
        this.gearRatioVar = new ComputedVariable(this, "gearRatio");
        this.addVariable(this.gearRatioVar);
        this.forceShiftVar = new ComputedVariable(this, "forceShift");
        this.addVariable(this.forceShiftVar);
        this.isAutomaticVar = new ComputedVariable(this, "isAutomatic");
        this.addVariable(this.isAutomaticVar);
        this.wearFactorVar = new ComputedVariable(this, "engineWearFactor");
        this.addVariable(this.wearFactorVar);
        this.winddownRateVar = new ComputedVariable(this, "engineWinddownRate");
        this.addVariable(this.winddownRateVar);
        this.jetPowerFactorVar = new ComputedVariable(this, "jetPowerFactor");
        this.addVariable(this.jetPowerFactorVar);
        this.bypassRatioVar = new ComputedVariable(this, "bypassRatio");
        this.addVariable(this.bypassRatioVar);
        if ((double)((JSONPart)this.definition).engine.gearRatios.size() <= this.currentGearVar.currentValue + (double)this.reverseGears) {
            this.currentGearVar.setTo(this.forwardsGears + this.reverseGears - 1, false);
        }
        if (this.vehicleOn != null && ((JSONVehicle)this.vehicleOn.definition).motorized.isAircraft) {
            this.currentGearVar.setTo(1.0, false);
        }
        if (this.vehicleOn != null && !this.vehicleOn.fuelTank.getFluid().isEmpty()) {
            switch (((JSONPart)this.definition).engine.type) {
                case MAGIC: {
                    break;
                }
                case ELECTRIC: {
                    if (this.vehicleOn.fuelTank.getFluid().equals(ELECTRICITY_FUEL)) break;
                    this.vehicleOn.fuelTank.clear();
                    break;
                }
                default: {
                    if (!ConfigSystem.settings.fuel.fuels.containsKey(((JSONPart)this.definition).engine.fuelType)) {
                        throw new IllegalArgumentException("Engine:" + ((JSONPart)this.definition).packID + ":" + ((JSONPart)this.definition).systemName + " wanted fuel configs for fuel of type:" + ((JSONPart)this.definition).engine.fuelType + ", but these do not exist in the config file.  Fuels currently in the file are:" + ConfigSystem.settings.fuel.fuels.keySet() + "If you are on a server, this means the server and client configs are not the same.  If this is a modpack, TELL THE AUTHOR IT IS BROKEN!");
                    }
                    if (ConfigSystem.settings.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).containsKey(this.vehicleOn.fuelTank.getFluid())) break;
                    this.vehicleOn.fuelTank.clear();
                }
            }
        }
    }

    @Override
    public void attack(Damage damage) {
        super.attack(damage);
        if (!damage.isWater) {
            if (((JSONPart)this.definition).engine.disableAutomaticStarter && damage.entityResponsible instanceof IWrapperPlayer && ((IWrapperPlayer)damage.entityResponsible).getHeldStack().isEmpty() && !this.masterEntity.allParts.contains(damage.entityResponsible.getEntityRiding())) {
                this.handStartEngine();
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.HS_ON));
                return;
            }
            if (this.vehicleOn == null || !this.vehicleOn.isCreative) {
                double hoursApplied = damage.amount * (Double)ConfigSystem.settings.general.engineHoursFactor.value;
                if (damage.isExplosion) {
                    hoursApplied *= 10.0;
                }
                this.hoursVar.adjustBy(hoursApplied, false);
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, hoursApplied));
            }
        } else if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
            this.stallEngine(PacketPartEngine.Signal.DROWN);
            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DROWN));
        }
    }

    @Override
    public void update() {
        super.update();
        this.backfired = false;
        this.badShift = false;
        if (this.running && !this.magnetoVar.isActive) {
            this.running = false;
            if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
                this.internalFuel = 200;
            }
        }
        this.fuelFlow = 0.0;
        if (this.upshiftCountdown > 0) {
            --this.upshiftCountdown;
        }
        if (this.downshiftCountdown > 0) {
            --this.downshiftCountdown;
        }
        if (this.vehicleOn != null) {
            if (this.linkedEngine != null) {
                if (!this.linkedEngine.position.isDistanceToCloserThan(this.position, 16.0)) {
                    this.linkedEngine.linkedEngine = null;
                    this.linkedEngine = null;
                    if (this.world.isClient()) {
                        for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                            player.displayChatMessage(LanguageSystem.INTERACT_JUMPERCABLE_LINKDROPPED, new Object[0]);
                        }
                    }
                } else if (this.vehicleOn.electricPower + 0.5 < this.linkedEngine.vehicleOn.electricPower) {
                    this.linkedEngine.vehicleOn.electricPower -= (double)0.005f;
                    this.vehicleOn.electricPower += (double)0.005f;
                } else if (this.vehicleOn.electricPower > this.linkedEngine.vehicleOn.electricPower + 0.5) {
                    this.vehicleOn.electricPower -= (double)0.005f;
                    this.linkedEngine.vehicleOn.electricPower += (double)0.005f;
                } else {
                    this.linkedEngine.linkedEngine = null;
                    this.linkedEngine = null;
                    if (this.world.isClient()) {
                        for (IWrapperPlayer player : this.world.getPlayersWithin(new BoundingBox(this.position, 16.0, 16.0, 16.0))) {
                            player.displayChatMessage(LanguageSystem.INTERACT_JUMPERCABLE_POWEREQUAL, new Object[0]);
                        }
                    }
                }
            }
            this.ambientTemp = (double)(25.0f * this.world.getTemperature(this.position) + 5.0f) * (Double)ConfigSystem.settings.general.engineBiomeTempFactor.value;
            this.coolingFactor = this.running ? 0.001 * this.coolingCoefficientVar.currentValue - this.superchargerEfficiencyVar.currentValue / 1000.0 * (this.rpm / 2000.0) + this.vehicleOn.velocity / 1000.0 * this.coolingCoefficientVar.currentValue : 0.001 * this.coolingCoefficientVar.currentValue + this.vehicleOn.velocity / 1000.0 * this.coolingCoefficientVar.currentValue;
            this.temp -= (this.temp - this.ambientTemp) * this.coolingFactor;
            if (this.electricStarterVar.isActive) {
                if ((this.outOfHealth || this.vehicleOn.outOfHealth) && !this.world.isClient()) {
                    this.electricStarterVar.toggle(true);
                    this.starterLevel = 0;
                    this.autoStarterEngaged = false;
                } else {
                    if (this.starterLevel == 0) {
                        if (this.vehicleOn.electricPower > 1.0) {
                            this.starterLevel += 4;
                        } else if (!this.world.isClient()) {
                            this.electricStarterVar.toggle(true);
                        }
                    }
                    if (this.starterLevel > 0 && !this.vehicleOn.isCreative) {
                        this.vehicleOn.electricUsageVar.adjustBy(0.05f, false);
                    }
                    if (this.autoStarterEngaged && !this.world.isClient() && this.running) {
                        this.electricStarterVar.setTo(0.0, true);
                    }
                }
            } else if (this.handStarterVar.isActive) {
                if (this.starterLevel == 0) {
                    this.handStarterVar.setTo(0.0, false);
                }
            } else {
                this.starterLevel = 0;
                this.autoStarterEngaged = false;
            }
            if (this.starterLevel > 0) {
                --this.starterLevel;
                this.rpm = this.rpm < this.startRPMVar.currentValue * 2.0 ? Math.min(this.rpm + this.starterPowerVar.currentValue, this.startRPMVar.currentValue * 2.0) : Math.max(this.rpm - this.starterPowerVar.currentValue, this.startRPMVar.currentValue * 2.0);
            }
            if (!this.vehicleOn.isCreative && this.rpm > this.maxSafeRPMVar.currentValue) {
                this.hoursVar.adjustBy((this.rpm - this.maxSafeRPMVar.currentValue) / this.maxSafeRPMVar.currentValue * this.getTotalWearFactor(), false);
            }
            if (this.shiftNeutralVar.isActive) {
                this.shiftNeutralVar.toggle(false);
                if (!this.world.isClient()) {
                    this.shiftNeutral();
                }
            } else if (this.shiftUpVar.isActive) {
                this.shiftUpVar.toggle(false);
                if (!this.world.isClient()) {
                    this.shiftUp();
                }
            } else if (this.shiftDownVar.isActive) {
                this.shiftDownVar.toggle(false);
                if (!this.world.isClient()) {
                    this.shiftDown();
                }
            } else if (this.shiftSelectionVar.isActive && !this.world.isClient() && this.shiftSelectionVar.currentValue != this.currentGearVar.currentValue) {
                if (this.shiftSelectionVar.currentValue < 10.0) {
                    while (this.currentGearVar.currentValue < this.shiftSelectionVar.currentValue && this.shiftUp()) {
                    }
                } else if (this.shiftSelectionVar.currentValue == 10.0) {
                    if (this.currentGearVar.currentValue == 0.0) {
                        this.shiftDown();
                    }
                } else if (this.shiftSelectionVar.currentValue == 11.0) {
                    this.shiftNeutral();
                }
            }
            if (((JSONVehicle)this.vehicleOn.definition).motorized.isBlimp && !this.linkedPropellers.isEmpty()) {
                if (this.vehicleOn.reverseThrustVar.isActive && this.currentGearVar.currentValue > 0.0) {
                    this.currentGearVar.setTo(-1.0, false);
                } else if (!this.vehicleOn.reverseThrustVar.isActive && this.currentGearVar.currentValue < 0.0) {
                    this.currentGearVar.setTo(1.0, false);
                }
            }
            this.drivenWheels.clear();
            for (PartGroundDevice wheel : this.linkedWheels) {
                if (wheel.isSpare || !wheel.isActiveVar.isActive || !((JSONPart)wheel.definition).ground.isWheel && !((JSONPart)wheel.definition).ground.isTread) continue;
                this.drivenWheels.add(wheel);
                wheel.drivenLastTick = true;
            }
            if (this.running) {
                if (!this.vehicleOn.isCreative) {
                    this.hoursVar.adjustBy(0.001 * this.getTotalWearFactor(), false);
                }
                if (!this.world.isClient()) {
                    if (!this.isActiveVar.isActive) {
                        this.stallEngine(PacketPartEngine.Signal.INACTIVE);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.INACTIVE));
                    } else if (this.outOfHealth || this.vehicleOn.outOfHealth) {
                        this.stallEngine(PacketPartEngine.Signal.OUT_OF_HEALTH);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.OUT_OF_HEALTH));
                    } else if (this.isInvalidDimension()) {
                        this.stallEngine(PacketPartEngine.Signal.INVALID_DIMENSION);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.INVALID_DIMENSION));
                    }
                }
                if (this.isAutomaticVar.isActive && !this.world.isClient() && this.currentGearVar.currentValue != 0.0) {
                    if (this.shiftCooldown == 0) {
                        if (this.currentGearVar.currentValue > 0.0 ? this.currentGearVar.currentValue < (double)this.forwardsGears : -this.currentGearVar.currentValue < (double)this.reverseGears) {
                            double d = ((JSONPart)this.definition).engine.upShiftRPM != null ? (double)((JSONPart)this.definition).engine.upShiftRPM.get((int)(this.currentGearVar.currentValue + (double)this.reverseGears)).intValue() : this.maxSafeRPMVar.currentValue * 0.9;
                            if (this.rpm > d * 0.5 * (1.0 + this.vehicleOn.throttleVar.currentValue)) {
                                if (this.currentGearVar.currentValue > 0.0) {
                                    this.shiftUp();
                                } else {
                                    this.shiftDown();
                                }
                            }
                        }
                        if (this.currentGearVar.currentValue > 1.0 || this.currentGearVar.currentValue < -1.0) {
                            double d = ((JSONPart)this.definition).engine.downShiftRPM != null ? (double)((JSONPart)this.definition).engine.downShiftRPM.get((int)(this.currentGearVar.currentValue + (double)this.reverseGears)).intValue() * 0.5 * (1.0 + this.vehicleOn.throttleVar.currentValue) : this.maxSafeRPMVar.currentValue * 0.9 * 0.25 * (1.0 + this.vehicleOn.throttleVar.currentValue);
                            if (this.rpm < d) {
                                if (this.currentGearVar.currentValue > 0.0) {
                                    this.shiftDown();
                                } else {
                                    this.shiftUp();
                                }
                            }
                        }
                    } else {
                        --this.shiftCooldown;
                    }
                }
                if (this.temp > (double)115.556f && !this.vehicleOn.isCreative) {
                    this.hoursVar.adjustBy(0.001 * (this.temp - (double)115.556f) * this.getTotalWearFactor(), false);
                    if (this.temp > (double)132.222f && !this.world.isClient()) {
                        this.explodeEngine();
                    }
                }
            }
            switch (((JSONPart)this.definition).engine.type) {
                case NORMAL: {
                    if (this.running) {
                        this.vehicleOn.electricUsageVar.adjustBy(-0.05 * this.rpm / this.maxRPMVar.currentValue, false);
                        if (!this.vehicleOn.isCreative && !this.vehicleOn.fuelTank.getFluid().isEmpty()) {
                            Double fuelFactor = ConfigSystem.settings.fuel.fuels.get(((JSONPart)this.definition).engine.fuelType).get(this.vehicleOn.fuelTank.getFluid());
                            if (fuelFactor == null) {
                                throw new IllegalStateException("Found vehicle " + this.vehicleOn + " with fluid " + this.vehicleOn.fuelTank.getFluid() + " in the fuel tank, but that fluid isn't valid for engine type " + ((JSONPart)this.definition).engine.fuelType + "!  This likely means you have mis-matched configs between your client and a server.  mtsconfig.json needs to be copied manually over and should be in your modpack!");
                            }
                            this.fuelFlow += this.vehicleOn.fuelTank.drain(this.getTotalFuelConsumption() * (Double)ConfigSystem.settings.general.fuelUsageFactor.value / fuelFactor * this.rpm / this.maxRPMVar.currentValue, !this.world.isClient());
                        }
                        this.temp += Math.max(0.0, (7.0 * this.rpm / this.maxRPMVar.currentValue - this.temp / 60.0) / 20.0) * this.heatingCoefficientVar.currentValue * (Double)ConfigSystem.settings.general.engineSpeedTempFactor.value;
                        this.pressure = Math.min(90.0 - this.temp / 10.0, this.pressure + this.rpm / this.idleRPMVar.currentValue - 0.5 * (this.pressure / 40.0));
                        if (this.pressure < 40.0 && !this.vehicleOn.isCreative) {
                            this.temp += Math.max(0.0, 20.0 * this.rpm / this.maxRPMVar.currentValue / 20.0);
                            this.hoursVar.adjustBy(0.01 * this.getTotalWearFactor(), false);
                        }
                        if (this.hoursVar.currentValue >= 500.0 && !this.world.isClient() && Math.random() < this.hoursVar.currentValue / 3.0 / (500.0 + (10000.0 - this.hoursVar.currentValue)) * (this.maxSafeRPMVar.currentValue / (this.rpm + this.maxSafeRPMVar.currentValue / 1.5))) {
                            this.backfireEngine();
                            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BACKFIRE));
                        }
                        if (this.world.isClient()) break;
                        if (this.isInLiquid()) {
                            this.stallEngine(PacketPartEngine.Signal.DROWN);
                            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.DROWN));
                            break;
                        }
                        if (!this.vehicleOn.isCreative && (Double)ConfigSystem.settings.general.fuelUsageFactor.value != 0.0 && this.vehicleOn.fuelTank.getFluidLevel() == 0.0) {
                            this.stallEngine(PacketPartEngine.Signal.FUEL_OUT);
                            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.FUEL_OUT));
                            break;
                        }
                        if (this.rpm < this.stallRPMVar.currentValue) {
                            this.stallEngine(PacketPartEngine.Signal.TOO_SLOW);
                            InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.TOO_SLOW));
                            break;
                        }
                        if (this.isActiveVar.isActive) break;
                        this.stallEngine(PacketPartEngine.Signal.INACTIVE);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.INACTIVE));
                        break;
                    }
                    if (this.internalFuel > 0) {
                        --this.internalFuel;
                        if (this.rpm < 500.0) {
                            this.internalFuel = 0;
                        }
                    }
                    if (!(this.rpm >= this.startRPMVar.currentValue) || this.world.isClient() || this.outOfHealth || this.vehicleOn.outOfHealth || this.isInvalidDimension() || !this.vehicleOn.isCreative && (Double)ConfigSystem.settings.general.fuelUsageFactor.value != 0.0 && !(this.vehicleOn.fuelTank.getFluidLevel() > 0.0) || !this.isActiveVar.isActive || this.isInLiquid() || !this.magnetoVar.isActive) break;
                    this.startEngine();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.START));
                    break;
                }
                case ROCKET: {
                    if (this.running) {
                        this.rocketFuelUsed += this.getTotalFuelConsumption();
                        if (this.isActiveVar.isActive && !(this.rocketFuelUsed >= (double)((JSONPart)this.definition).engine.rocketFuel)) break;
                        this.running = false;
                        break;
                    }
                    if (!this.isActiveVar.isActive || this.outOfHealth || !this.magnetoVar.isActive || !(this.rocketFuelUsed < (double)((JSONPart)this.definition).engine.rocketFuel)) break;
                    this.running = true;
                    break;
                }
                case ELECTRIC: {
                    if (this.running) {
                        this.vehicleOn.electricUsageVar.adjustBy(-0.05 * this.rpm / this.maxRPMVar.currentValue, false);
                        if (!this.vehicleOn.isCreative && !this.vehicleOn.fuelTank.getFluid().isEmpty()) {
                            this.fuelFlow += this.vehicleOn.fuelTank.drain(this.getTotalFuelConsumption() * (Double)ConfigSystem.settings.general.fuelUsageFactor.value * this.rpm / this.maxRPMVar.currentValue, !this.world.isClient());
                        }
                        if (this.world.isClient() || this.vehicleOn.isCreative || (Double)ConfigSystem.settings.general.fuelUsageFactor.value == 0.0 || this.vehicleOn.fuelTank.getFluidLevel() != 0.0) break;
                        this.stallEngine(PacketPartEngine.Signal.FUEL_OUT);
                        InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.FUEL_OUT));
                        break;
                    }
                    if (this.world.isClient() || this.outOfHealth || this.vehicleOn.outOfHealth || !this.isActiveVar.isActive || !this.vehicleOn.isCreative && (Double)ConfigSystem.settings.general.fuelUsageFactor.value != 0.0 && !(this.vehicleOn.fuelTank.getFluidLevel() > 0.0) || !this.magnetoVar.isActive) break;
                    this.startEngine();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.START));
                    break;
                }
                case MAGIC: {
                    if (this.running) {
                        this.vehicleOn.electricUsageVar.adjustBy(-0.05 * this.rpm / this.maxRPMVar.currentValue, false);
                        break;
                    }
                    if (this.world.isClient() || this.outOfHealth || this.vehicleOn.outOfHealth || !this.isActiveVar.isActive || !this.magnetoVar.isActive) break;
                    this.startEngine();
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.START));
                }
            }
            this.wheelFriction = 0.0f;
            if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f && !this.drivenWheels.isEmpty()) {
                this.lowestWheelVelocity = 999.0;
                this.desiredWheelVelocity = -999.0;
                this.engineTargetRPM = !this.electricStarterVar.isActive ? this.vehicleOn.throttleVar.currentValue * (this.maxRPMVar.currentValue - this.idleRPMVar.currentValue) / (1.0 + this.hoursVar.currentValue / 1500.0) + this.idleRPMVar.currentValue : this.startRPMVar.currentValue;
                for (PartGroundDevice wheel : this.drivenWheels) {
                    if (!this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(wheel)) continue;
                    this.wheelFriction = (float)((double)this.wheelFriction + wheel.motiveFrictionVar.currentValue);
                    this.lowestWheelVelocity = Math.min(wheel.angularVelocity, this.lowestWheelVelocity);
                    this.desiredWheelVelocity = Math.max(wheel.getDesiredAngularVelocity(), this.desiredWheelVelocity);
                }
                if (this.gearRatioVar.currentValue != 0.0 && this.starterLevel == 0) {
                    if (this.wheelFriction > 0.0f) {
                        double desiredRPM = this.lowestWheelVelocity * 1200.0 * this.gearRatioVar.currentValue * this.vehicleOn.axleRatioVar.currentValue;
                        this.rpm += (desiredRPM - this.rpm) / this.revResistanceVar.currentValue;
                        if (this.rpm < this.idleRPMVar.currentValue - (this.idleRPMVar.currentValue - this.stallRPMVar.currentValue) * 0.5 && this.running) {
                            this.rpm = this.idleRPMVar.currentValue - (this.idleRPMVar.currentValue - this.stallRPMVar.currentValue) * 0.5;
                        }
                    } else {
                        for (PartGroundDevice wheel : this.drivenWheels) {
                            wheel.angularVelocity = this.rpm / this.gearRatioVar.currentValue / this.vehicleOn.axleRatioVar.currentValue / 1200.0;
                        }
                    }
                }
            }
            this.propellerGearboxRatio = Math.signum(this.gearRatioVar.currentValue) * (((JSONPart)this.definition).engine.propellerRatio != 0.0f ? (double)((JSONPart)this.definition).engine.propellerRatio : Math.abs(this.gearRatioVar.currentValue));
            for (PartPropeller attachedPropeller : this.linkedPropellers) {
                if (attachedPropeller.ticksExisted == 0L || this.wheelFriction != 0.0f || this.gearRatioVar.currentValue == 0.0) continue;
                boolean isPropellerInLiquid = attachedPropeller.isInLiquid();
                double propellerForcePenalty = Math.max(0.0, (double)(((JSONPart)attachedPropeller.definition).propeller.diameter - 75) / (50.0 * (this.fuelConsumptionVar.currentValue + this.superchargerFuelConsumptionVar.currentValue * this.superchargerEfficiencyVar.currentValue) - 15.0));
                double propellerFeedback = -Math.abs(attachedPropeller.airstreamLinearVelocity - attachedPropeller.desiredLinearVelocity) * (isPropellerInLiquid ? 6.5 : 2.0);
                if (this.running) {
                    propellerFeedback -= propellerForcePenalty * 50.0;
                    this.engineTargetRPM = this.vehicleOn.throttleVar.currentValue * (this.maxRPMVar.currentValue - this.idleRPMVar.currentValue) / (1.0 + this.hoursVar.currentValue / 1500.0) + this.idleRPMVar.currentValue;
                    double engineRPMDifference = this.engineTargetRPM - this.rpm;
                    if (this.rpm + engineRPMDifference / this.revResistanceVar.currentValue > this.stallRPMVar.currentValue && this.rpm + engineRPMDifference / this.revResistanceVar.currentValue + propellerFeedback < this.stallRPMVar.currentValue) {
                        this.rpm = this.stallRPMVar.currentValue;
                        continue;
                    }
                    this.rpm += engineRPMDifference / this.revResistanceVar.currentValue + propellerFeedback;
                    continue;
                }
                if (this.electricStarterVar.isActive || this.handStarterVar.isActive) continue;
                this.rpm += (propellerFeedback - 1.0) * Math.abs(this.propellerGearboxRatio);
                if (!(this.rpm < 0.0)) continue;
                this.rpm = 0.0;
            }
            if (this.wheelFriction == 0.0f && this.linkedPropellers.isEmpty() || this.gearRatioVar.currentValue == 0.0) {
                if (this.running) {
                    this.engineTargetRPM = this.rocketFuelUsed < (double)((JSONPart)this.definition).engine.rocketFuel ? this.maxRPMVar.currentValue : this.vehicleOn.throttleVar.currentValue * (this.maxRPMVar.currentValue - this.idleRPMVar.currentValue) / (1.0 + this.hoursVar.currentValue / 1500.0) + this.idleRPMVar.currentValue;
                    this.rpm += (this.engineTargetRPM - this.rpm) / (this.revResistanceVar.currentValue * 3.0);
                    if (this.revLimitRPMVar.currentValue == -1.0) {
                        if (this.rpm > this.maxSafeRPMVar.currentValue) {
                            this.rpm -= Math.abs(this.engineTargetRPM - this.rpm) / 60.0;
                        }
                    } else if (this.rpm > this.revLimitRPMVar.currentValue) {
                        this.rpm -= Math.abs(this.engineTargetRPM - this.rpm) / this.revLimitBounceVar.currentValue;
                    }
                } else if (!this.electricStarterVar.isActive && !this.handStarterVar.isActive) {
                    this.rpm = Math.max(this.rpm - this.winddownRateVar.currentValue, 0.0);
                }
            }
            if (((JSONPart)this.definition).engine.jetPowerFactor > 0.0f) {
                this.engineAxisVector.set(0.0, 0.0, 1.0).rotate(this.orientation);
                this.engineAxialVelocity = this.vehicleOn.motion.dotProduct(this.engineAxisVector, false);
                if (!this.world.isClient() && this.rpm >= 5000.0) {
                    this.boundingBox.widthRadius += 0.25;
                    this.boundingBox.heightRadius += 0.25;
                    this.boundingBox.depthRadius += 0.25;
                    this.boundingBox.globalCenter.add(this.vehicleOn.headingVector);
                    IWrapperEntity controller = this.getController();
                    LanguageSystem.LanguageEntry language = controller != null ? LanguageSystem.DEATH_JETINTAKE_PLAYER : LanguageSystem.DEATH_JETINTAKE_NULL;
                    Damage jetIntake = new Damage((double)((JSONPart)this.definition).engine.jetPowerFactor * (Double)ConfigSystem.settings.damage.jetDamageFactor.value * this.rpm / 1000.0, this.boundingBox, this, controller, language);
                    this.world.attackEntities(jetIntake, null, false);
                    this.boundingBox.globalCenter.subtract(this.vehicleOn.headingVector);
                    this.boundingBox.globalCenter.subtract(this.vehicleOn.headingVector);
                    language = controller != null ? LanguageSystem.DEATH_JETEXHAUST_PLAYER : LanguageSystem.DEATH_JETEXHAUST_NULL;
                    Damage jetExhaust = new Damage((double)((JSONPart)this.definition).engine.jetPowerFactor * (Double)ConfigSystem.settings.damage.jetDamageFactor.value * this.rpm / 2000.0, this.boundingBox, this, controller, language).setFire();
                    this.world.attackEntities(jetExhaust, null, false);
                    this.boundingBox.globalCenter.add(this.vehicleOn.headingVector);
                    this.boundingBox.widthRadius -= 0.25;
                    this.boundingBox.heightRadius -= 0.25;
                    this.boundingBox.depthRadius -= 0.25;
                }
            }
            this.prevEngineRotation = this.engineRotation;
            this.engineRotation += 360.0 * this.rpm / 1200.0;
            if (this.engineRotation > 3600000.0) {
                this.engineRotation -= 3600000.0;
                this.prevEngineRotation -= 3600000.0;
            } else if (this.engineRotation < -3600000.0) {
                this.engineRotation += 3600000.0;
                this.prevEngineRotation += 3600000.0;
            }
            this.prevDriveshaftRotation = this.driveshaftRotation;
            double driveshaftDesiredSpeed = -999.0;
            for (PartGroundDevice wheel : this.drivenWheels) {
                driveshaftDesiredSpeed = Math.max(wheel.angularVelocity, driveshaftDesiredSpeed);
            }
            if (driveshaftDesiredSpeed != -999.0) {
                this.driveshaftRotation += 360.0 * driveshaftDesiredSpeed * this.vehicleOn.speedFactor;
            } else if (this.propellerGearboxRatio != 0.0) {
                this.driveshaftRotation += 360.0 * this.rpm / 1200.0 / this.propellerGearboxRatio;
            }
            if (this.driveshaftRotation > 3600000.0) {
                this.driveshaftRotation -= 3600000.0;
                this.prevDriveshaftRotation -= 3600000.0;
            } else if (this.driveshaftRotation < -3600000.0) {
                this.driveshaftRotation += 3600000.0;
                this.prevDriveshaftRotation += 3600000.0;
            }
        }
    }

    public boolean isInvalidDimension() {
        return ((Set)ConfigSystem.settings.general.engineDimensionWhitelist.value).isEmpty() ? ((Set)ConfigSystem.settings.general.engineDimensionBlacklist.value).contains(this.world.getName()) : !((Set)ConfigSystem.settings.general.engineDimensionWhitelist.value).contains(this.world.getName());
    }

    @Override
    public void updatePartList() {
        super.updatePartList();
        this.linkedWheels.clear();
        this.addLinkedPartsToList(this.linkedWheels, PartGroundDevice.class);
        ArrayList fakeWheels = new ArrayList();
        this.linkedWheels.forEach(wheel -> {
            if (wheel.fakePart != null) {
                fakeWheels.add(wheel.fakePart);
            }
        });
        this.linkedWheels.addAll(fakeWheels);
        this.linkedPropellers.clear();
        this.parts.forEach(part -> {
            if (part instanceof PartPropeller) {
                this.linkedPropellers.add((PartPropeller)part);
            }
        });
        this.addLinkedPartsToList(this.linkedPropellers, PartPropeller.class);
    }

    @Override
    public void setVariableDefaults() {
        super.setVariableDefaults();
        this.maxRPMVar.setTo(((JSONPart)this.definition).engine.maxRPM, false);
        this.maxSafeRPMVar.setTo(((JSONPart)this.definition).engine.maxSafeRPM, false);
        this.revLimitRPMVar.setTo(((JSONPart)this.definition).engine.revlimitRPM, false);
        this.revLimitBounceVar.setTo(((JSONPart)this.definition).engine.revlimitBounce, false);
        this.revResistanceVar.setTo(((JSONPart)this.definition).engine.revResistance, false);
        this.idleRPMVar.setTo(((JSONPart)this.definition).engine.idleRPM, false);
        this.startRPMVar.setTo(((JSONPart)this.definition).engine.startRPM, false);
        this.stallRPMVar.setTo(((JSONPart)this.definition).engine.stallRPM, false);
        this.starterPowerVar.setTo(((JSONPart)this.definition).engine.starterPower, false);
        this.fuelConsumptionVar.setTo(((JSONPart)this.definition).engine.fuelConsumption, false);
        this.heatingCoefficientVar.setTo(((JSONPart)this.definition).engine.heatingCoefficient, false);
        this.coolingCoefficientVar.setTo(((JSONPart)this.definition).engine.coolingCoefficient, false);
        this.superchargerFuelConsumptionVar.setTo(((JSONPart)this.definition).engine.superchargerFuelConsumption, false);
        this.superchargerEfficiencyVar.setTo(((JSONPart)this.definition).engine.superchargerEfficiency, false);
        this.gearRatioVar.setTo(((JSONPart)this.definition).engine.gearRatios.get((int)this.currentGearVar.currentValue + this.reverseGears).floatValue(), false);
        this.forceShiftVar.setActive(((JSONPart)this.definition).engine.forceShift, false);
        this.isAutomaticVar.setActive(((JSONPart)this.definition).engine.isAutomatic, false);
        this.wearFactorVar.setTo(((JSONPart)this.definition).engine.engineWearFactor, false);
        this.winddownRateVar.setTo(((JSONPart)this.definition).engine.engineWinddownRate, false);
        this.jetPowerFactorVar.setTo(((JSONPart)this.definition).engine.jetPowerFactor, false);
        this.bypassRatioVar.setTo(((JSONPart)this.definition).engine.bypassRatio, false);
    }

    @Override
    public boolean isInLiquid() {
        return this.world.isBlockLiquid(this.position.copy().add(0.0, this.placementDefinition.intakeOffset, 0.0));
    }

    @Override
    public void remove() {
        super.remove();
        if (this.vehicleOn != null) {
            for (PartGroundDevice wheel : this.drivenWheels) {
                wheel.skipAngularCalcs = false;
            }
        }
    }

    @Override
    public ComputedVariable createComputedVariable(String variable, boolean createDefaultIfNotPresent) {
        switch (variable) {
            case "engine_rotation": {
                return new ComputedVariable(this, variable, partialTicks -> this.getEngineRotation(partialTicks), true);
            }
            case "engine_sin": {
                return new ComputedVariable(this, variable, partialTicks -> Math.sin(Math.toRadians(this.getEngineRotation(partialTicks))), true);
            }
            case "engine_cos": {
                return new ComputedVariable(this, variable, partialTicks -> Math.cos(Math.toRadians(this.getEngineRotation(partialTicks))), true);
            }
            case "engine_driveshaft_rotation": {
                return new ComputedVariable(this, variable, partialTicks -> this.getDriveshaftRotation(partialTicks), true);
            }
            case "engine_driveshaft_sin": {
                return new ComputedVariable(this, variable, partialTicks -> Math.sin(Math.toRadians(this.getDriveshaftRotation(partialTicks))), true);
            }
            case "engine_driveshaft_cos": {
                return new ComputedVariable(this, variable, partialTicks -> Math.cos(Math.toRadians(this.getDriveshaftRotation(partialTicks))), true);
            }
            case "engine_rpm": {
                return new ComputedVariable(this, variable, partialTicks -> this.rpm, false);
            }
            case "engine_rpm_percent": {
                return new ComputedVariable(this, variable, partialTicks -> this.rpm / this.maxRPMVar.currentValue, false);
            }
            case "engine_rpm_percent_safe": {
                return new ComputedVariable(this, variable, partialTicks -> this.rpm / this.maxSafeRPMVar.currentValue, false);
            }
            case "engine_rpm_percent_revlimit": {
                return new ComputedVariable(this, variable, partialTicks -> this.revLimitRPMVar.currentValue != -1.0 ? this.rpm / this.revLimitRPMVar.currentValue : this.rpm / this.maxSafeRPMVar.currentValue, false);
            }
            case "engine_rpm_target": {
                return new ComputedVariable(this, variable, partialTicks -> this.engineTargetRPM, false);
            }
            case "engine_fuel_flow": {
                return new ComputedVariable(this, variable, partialTicks -> this.fuelFlow * 20.0 * 60.0 / 1000.0, false);
            }
            case "engine_fuel_remaining": {
                return new ComputedVariable(this, variable, partialTicks -> ((double)((JSONPart)this.definition).engine.rocketFuel - this.rocketFuelUsed) / (double)((JSONPart)this.definition).engine.rocketFuel, false);
            }
            case "engine_temp": {
                return new ComputedVariable(this, variable, partialTicks -> this.temp, false);
            }
            case "engine_temp_ambient": {
                return new ComputedVariable(this, variable, partialTicks -> this.ambientTemp, false);
            }
            case "engine_pressure": {
                return new ComputedVariable(this, variable, partialTicks -> this.pressure, false);
            }
            case "engine_gearshift": {
                return new ComputedVariable(this, variable, partialTicks -> this.getGearshiftRotation(), false);
            }
            case "engine_gearshift_hvertical": {
                return new ComputedVariable(this, variable, partialTicks -> this.getGearshiftPosition_Vertical(), false);
            }
            case "engine_gearshift_hhorizontal": {
                return new ComputedVariable(this, variable, partialTicks -> this.getGearshiftPosition_Horizontal(), false);
            }
            case "engine_clutch_upshift": {
                return new ComputedVariable(this, variable, partialTicks -> this.upshiftCountdown > 0 ? 1.0 : 0.0, false);
            }
            case "engine_clutch_downshift": {
                return new ComputedVariable(this, variable, partialTicks -> this.downshiftCountdown > 0 ? 1.0 : 0.0, false);
            }
            case "engine_badshift": {
                return new ComputedVariable(this, variable, partialTicks -> this.badShift ? 1.0 : 0.0, false);
            }
            case "engine_reversed": {
                return new ComputedVariable(this, variable, partialTicks -> this.currentGearVar.currentValue < 0.0 ? 1.0 : 0.0, false);
            }
            case "engine_running": {
                return new ComputedVariable(this, variable, partialTicks -> this.running ? 1.0 : 0.0, false);
            }
            case "engine_powered": {
                return new ComputedVariable(this, variable, partialTicks -> this.running || this.internalFuel > 0 ? 1.0 : 0.0, false);
            }
            case "engine_backfired": {
                return new ComputedVariable(this, variable, partialTicks -> this.backfired ? 1.0 : 0.0, false);
            }
            case "engine_jumper_cable": {
                return new ComputedVariable(this, variable, partialTicks -> this.linkedEngine != null ? 1.0 : 0.0, false);
            }
        }
        if (variable.startsWith("engine_sin_")) {
            int offset = Integer.parseInt(variable.substring("engine_sin_".length()));
            return new ComputedVariable(this, variable, partialTicks -> Math.sin(Math.toRadians(this.getEngineRotation(partialTicks) + (double)offset)), true);
        }
        if (variable.startsWith("engine_cos_")) {
            int offset = Integer.parseInt(variable.substring("engine_cos_".length()));
            return new ComputedVariable(this, variable, partialTicks -> Math.cos(Math.toRadians(this.getEngineRotation(partialTicks) + (double)offset)), true);
        }
        if (variable.startsWith("engine_driveshaft_sin_")) {
            int offset = Integer.parseInt(variable.substring("engine_driveshaft_sin_".length()));
            return new ComputedVariable(this, variable, partialTicks -> Math.sin(Math.toRadians(this.getDriveshaftRotation(partialTicks) + (double)offset)), true);
        }
        if (variable.startsWith("engine_driveshaft_cos_")) {
            int offset = Integer.parseInt(variable.substring("engine_driveshaft_cos_".length()));
            return new ComputedVariable(this, variable, partialTicks -> Math.cos(Math.toRadians(this.getDriveshaftRotation(partialTicks) + (double)offset)), true);
        }
        if (variable.startsWith("engine_piston_")) {
            int camMultiplier;
            int totalPistons;
            int pistonNumber;
            int parsedTotalPistons;
            String[] parsedVariable = variable.split("_");
            int parsedPistonNumber = Integer.parseInt(parsedVariable[2]);
            if (parsedPistonNumber > (parsedTotalPistons = Integer.parseInt(parsedVariable[3])) || parsedTotalPistons == 1) {
                pistonNumber = 1;
                totalPistons = 2;
            } else {
                pistonNumber = parsedPistonNumber;
                totalPistons = parsedTotalPistons;
            }
            switch (parsedVariable[parsedVariable.length - 1]) {
                case "crank": {
                    camMultiplier = 1;
                    break;
                }
                case "cam": {
                    camMultiplier = 2;
                    break;
                }
                default: {
                    return new ComputedVariable(false);
                }
            }
            int offset = parsedVariable.length == 6 ? camMultiplier * Integer.parseInt(parsedVariable[4]) : 0;
            double sector = 360.0 * (double)camMultiplier / (double)totalPistons;
            return new ComputedVariable(this, variable, partialTicks -> {
                double shaftRotation = Math.floorMod(Math.round(10.0 * ((double)offset + this.getEngineRotation(partialTicks))), Math.round(3600.0 * (double)camMultiplier)) / 10L;
                return sector * (double)(pistonNumber - 1) <= shaftRotation && shaftRotation < sector + sector * (double)(pistonNumber - 1) ? 1.0 : 0.0;
            }, true);
        }
        return super.createComputedVariable(variable, createDefaultIfNotPresent);
    }

    public void startEngine() {
        this.running = true;
        if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
            this.pressure = 60.0;
        }
    }

    public void handStartEngine() {
        this.handStarterVar.setTo(1.0, false);
        this.starterLevel += 4;
    }

    public void autoStartEngine() {
        if (!this.vehicleOn.isCreative && (Double)ConfigSystem.settings.general.fuelUsageFactor.value != 0.0 && this.vehicleOn.fuelTank.getFluidLevel() == 0.0) {
            if (this.world.isClient()) {
                InterfaceManager.clientInterface.getClientPlayer().displayChatMessage(LanguageSystem.INTERACT_VEHICLE_NOFUEL, new Object[0]);
            }
        } else if (!(this.running || this.outOfHealth || this.vehicleOn.outOfHealth)) {
            this.magnetoVar.setTo(1.0, false);
            if (((JSONPart)this.definition).engine.type == JSONPart.EngineType.NORMAL) {
                this.autoStarterEngaged = true;
                this.electricStarterVar.setTo(1.0, false);
            }
        }
    }

    public void stallEngine(PacketPartEngine.Signal signal) {
        this.running = false;
        if (this.world.isClient() && signal != PacketPartEngine.Signal.DROWN && signal != PacketPartEngine.Signal.INVALID_DIMENSION && ((JSONPart)this.definition).engine.type != JSONPart.EngineType.ELECTRIC) {
            this.internalFuel = 100;
        }
    }

    public void backfireEngine() {
        this.backfired = true;
        this.rpm -= this.maxRPMVar.currentValue < 15000.0 ? (double)Math.round(0.05 * this.rpm + (this.hoursVar.currentValue * 0.05 - 25.0)) : (double)Math.round(0.1 * this.rpm + (this.hoursVar.currentValue * 0.1 - 50.0));
    }

    public void badShiftEngine() {
        this.badShift = true;
    }

    protected void explodeEngine() {
        this.world.spawnExplosion(this.position, 0.0, false, false);
        this.entityOn.removePart(this, false, true);
    }

    public double getGearshiftRotation() {
        return this.isAutomaticVar.isActive ? Math.min(1.0, this.currentGearVar.currentValue) * 15.0 : this.currentGearVar.currentValue * 5.0;
    }

    public float getGearshiftPosition_Vertical() {
        if (this.currentGearVar.currentValue < 0.0) {
            return ((JSONPart)this.definition).engine.gearRatios.size() % 2 == 0 ? 15.0f : -15.0f;
        }
        if (this.currentGearVar.currentValue == 0.0) {
            return 0.0f;
        }
        return this.currentGearVar.currentValue % 2.0 == 0.0 ? -15.0f : 15.0f;
    }

    public double getGearshiftPosition_Horizontal() {
        float columnAngleDelta;
        int columns = ((JSONPart)this.definition).engine.gearRatios.size() / 2;
        int firstColumnAngle = columns / 2 * -5;
        float f = columnAngleDelta = columns != 1 ? (float)(-firstColumnAngle * 2 / (columns - 1)) : 0.0f;
        if (this.currentGearVar.currentValue < 0.0) {
            return -firstColumnAngle;
        }
        if (this.currentGearVar.currentValue == 0.0) {
            return 0.0;
        }
        return (double)firstColumnAngle + (this.currentGearVar.currentValue - 1.0) / 2.0 * (double)columnAngleDelta;
    }

    public boolean shiftUp() {
        boolean doShift = false;
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f) {
            byte nextGear;
            if (this.currentGearVar.currentValue == (double)this.forwardsGears) {
                return false;
            }
            if (this.currentGearVar.currentValue == 0.0) {
                nextGear = 1;
                doShift = this.world.isClient() || this.vehicleOn.axialVelocity < (double)0.35f || this.wheelFriction == 0.0f || !this.vehicleOn.goingInReverse || this.forceShiftVar.isActive;
            } else {
                nextGear = (byte)(this.currentGearVar.currentValue + 1.0);
                doShift = true;
            }
            if (doShift) {
                this.currentGearVar.setTo(nextGear, false);
                this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
                this.upshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
                if (!this.world.isClient()) {
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.SHIFT_UP));
                }
            } else {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BAD_SHIFT));
            }
        }
        return doShift;
    }

    public boolean shiftDown() {
        boolean doShift = false;
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f) {
            int nextGear;
            if (this.currentGearVar.currentValue < 0.0 && -this.currentGearVar.currentValue == (double)this.reverseGears) {
                return false;
            }
            if (this.currentGearVar.currentValue == 0.0) {
                nextGear = -1;
                doShift = this.world.isClient() || this.vehicleOn.axialVelocity < (double)0.35f || this.wheelFriction == 0.0f || this.vehicleOn.goingInReverse || this.forceShiftVar.isActive;
            } else {
                nextGear = (byte)(this.currentGearVar.currentValue - 1.0);
                doShift = true;
            }
            if (doShift) {
                this.currentGearVar.setTo(nextGear, false);
                this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
                this.downshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
                if (!this.world.isClient()) {
                    InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.SHIFT_DOWN));
                }
            } else {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.BAD_SHIFT));
            }
        }
        return doShift;
    }

    public void shiftNeutral() {
        if (((JSONPart)this.definition).engine.jetPowerFactor == 0.0f && this.currentGearVar.currentValue != 0.0) {
            if (this.currentGearVar.currentValue > 0.0) {
                this.downshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            } else {
                this.upshiftCountdown = ((JSONPart)this.definition).engine.clutchTime;
            }
            this.shiftCooldown = ((JSONPart)this.definition).engine.shiftSpeed;
            this.currentGearVar.setTo(0.0, false);
            if (!this.world.isClient()) {
                InterfaceManager.packetInterface.sendToAllClients(new PacketPartEngine(this, PacketPartEngine.Signal.SHIFT_NEUTRAL));
            }
        }
    }

    public double getTotalFuelConsumption() {
        return this.fuelConsumptionVar.currentValue + this.superchargerFuelConsumptionVar.currentValue;
    }

    public double getTotalWearFactor() {
        if (this.superchargerEfficiencyVar.currentValue > 1.0) {
            return this.wearFactorVar.currentValue * this.superchargerEfficiencyVar.currentValue * (Double)ConfigSystem.settings.general.engineHoursFactor.value;
        }
        return this.wearFactorVar.currentValue * (Double)ConfigSystem.settings.general.engineHoursFactor.value;
    }

    public double getEngineRotation(float partialTicks) {
        return partialTicks != 0.0f ? this.prevEngineRotation + (this.engineRotation - this.prevEngineRotation) * (double)partialTicks : this.engineRotation;
    }

    public double getDriveshaftRotation(float partialTicks) {
        return partialTicks != 0.0f ? this.prevDriveshaftRotation + (this.driveshaftRotation - this.prevDriveshaftRotation) * (double)partialTicks : this.driveshaftRotation;
    }

    public double addToForceOutput(Point3D force, Point3D torque) {
        this.engineForce.set(0.0, 0.0, 0.0);
        this.engineForceValue = 0.0;
        if (!this.jetPowerFactorVar.isActive && this.wheelFriction != 0.0f) {
            double wheelForce;
            if (this.running || this.electricStarterVar.isActive) {
                wheelForce = this.rpm > this.revLimitRPMVar.currentValue && this.revLimitRPMVar.currentValue != -1.0 ? -this.rpm / this.maxRPMVar.currentValue * Math.signum(this.currentGearVar.currentValue) * 60.0 : (this.engineTargetRPM - this.rpm) / this.maxRPMVar.currentValue * this.gearRatioVar.currentValue * this.vehicleOn.axleRatioVar.currentValue * (this.fuelConsumptionVar.currentValue + this.superchargerFuelConsumptionVar.currentValue * this.superchargerEfficiencyVar.currentValue) * (double)0.6f * 30.0;
                if (wheelForce != 0.0) {
                    if (Math.abs(wheelForce / 300.0) > (double)this.wheelFriction || Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) > 0.1 && Math.abs(this.lowestWheelVelocity) - Math.abs(this.desiredWheelVelocity) < Math.abs(wheelForce / 300.0)) {
                        wheelForce *= this.vehicleOn.currentMass / 100000.0 * (double)this.wheelFriction / Math.abs(wheelForce / 300.0);
                        for (PartGroundDevice wheel : this.drivenWheels) {
                            wheel.angularVelocity = wheelForce >= 0.0 ? Math.min(this.engineTargetRPM / 1200.0 / this.gearRatioVar.currentValue / this.vehicleOn.axleRatioVar.currentValue, wheel.angularVelocity + 0.01) : Math.max(this.engineTargetRPM / 1200.0 / this.gearRatioVar.currentValue / this.vehicleOn.axleRatioVar.currentValue, wheel.angularVelocity - 0.01);
                            wheel.skipAngularCalcs = true;
                        }
                    } else {
                        for (PartGroundDevice wheel : this.drivenWheels) {
                            wheel.skipAngularCalcs = false;
                            if (this.vehicleOn.groundDeviceCollective.groundedGroundDevices.contains(wheel)) continue;
                            wheel.angularVelocity = this.lowestWheelVelocity;
                        }
                    }
                } else if (this.gearRatioVar.currentValue == 0.0) {
                    for (PartGroundDevice wheel : this.drivenWheels) {
                        wheel.skipAngularCalcs = false;
                    }
                }
                if ((wheelForce < 0.0 && this.gearRatioVar.currentValue > 0.0 || wheelForce > 0.0 && this.gearRatioVar.currentValue < 0.0) && this.vehicleOn.velocity < 0.25) {
                    wheelForce = 0.0;
                }
            } else {
                wheelForce = -this.rpm / this.maxRPMVar.currentValue * Math.signum(this.currentGearVar.currentValue) * 30.0;
            }
            this.engineForceValue += wheelForce;
            this.engineForce.set(0.0, 0.0, wheelForce).rotate(this.vehicleOn.orientation);
            force.add(this.engineForce);
        }
        if (this.jetPowerFactorVar.isActive && this.running) {
            double safeRPMFactor = this.rpm / this.maxSafeRPMVar.currentValue;
            double coreContribution = Math.max(10.0 * this.vehicleOn.airDensity * this.fuelConsumptionVar.currentValue * safeRPMFactor - this.bypassRatioVar.currentValue, 0.0);
            double fanVelocityFactor = (6.35 * this.rpm / 60.0 / 20.0 - this.engineAxialVelocity) / 200.0;
            double fanContribution = 10.0 * this.vehicleOn.airDensity * safeRPMFactor * fanVelocityFactor * this.bypassRatioVar.currentValue;
            double thrust = (this.vehicleOn.reverseThrustVar.isActive ? -(coreContribution + fanContribution) : coreContribution + fanContribution) * this.jetPowerFactorVar.currentValue;
            this.engineForceValue += thrust;
            this.engineForce.set(this.engineAxisVector).scale(thrust);
            force.add(this.engineForce);
            this.engineForce.reOrigin(this.vehicleOn.orientation);
            if (((JSONPart)this.definition).engine.allowThrustVector) {
                torque.add(this.localOffset.crossProduct(this.engineForce));
            } else {
                torque.y -= this.engineForce.z * this.localOffset.x + this.engineForce.x * this.localOffset.z;
                torque.z += this.engineForce.y * this.localOffset.x - this.engineForce.x * this.localOffset.y;
            }
        }
        return this.engineForceValue;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setBoolean("running", this.running);
        data.setDouble("rpm", this.rpm);
        data.setDouble("temp", this.temp);
        data.setDouble("pressure", this.pressure);
        data.setDouble("rocketFuelUsed", this.rocketFuelUsed);
        return data;
    }
}

